#include <windows.h>
#include "..\\Lib\\aml.h"

#pragma comment(lib, "..\\Lib\\aml.lib") 

BOOL CreateVideoWindow(HINSTANCE hInstance);
void DestroyVideoWindow(HINSTANCE hInstance);

HWND pWnd = NULL;

LRESULT CALLBACK WndProc(HWND pWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_CLOSE:
		{
			PostQuitMessage(0);
			return 0;
		}
	}

	return DefWindowProc(pWnd,uMsg,wParam,lParam);
}

BOOL CreateVideoWindow(HINSTANCE hInstance)
{
	WNDCLASS wc;
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hIcon			= NULL;
	wc.lpszMenuName		= NULL;
	wc.cbWndExtra		= 0; 
	wc.cbClsExtra		= 0; 
	wc.lpszClassName	= "PlayVideo";
	wc.lpfnWndProc		= (WNDPROC)WndProc;
	wc.hInstance		= hInstance;
	wc.hbrBackground	= NULL;
	wc.style			= CS_HREDRAW | CS_VREDRAW;

	if (!RegisterClass(&wc))
	{
		MessageBox(NULL, "Failed To Register The Window Class", "Error", 0);
		return FALSE;
	}

	if (!(pWnd = CreateWindowEx(0, "PlayVideo", "Play Video", WS_VISIBLE | WS_OVERLAPPEDWINDOW, 10, 10, 200, 200, NULL, NULL, hInstance, NULL)))
	{
		DestroyVideoWindow(hInstance);
		MessageBox(NULL, "Window Creation Error", "Error", 0);
		return FALSE;
	}

	ShowWindow(pWnd, SW_SHOW);
	SetForegroundWindow(pWnd);
	SetFocus(pWnd);

	return TRUE;
}

void DestroyVideoWindow(HINSTANCE hInstance)
{
	if (pWnd && !DestroyWindow(pWnd))
	{
		MessageBox(NULL, "Could Not Release pWnd", "Error", 0);
		pWnd = NULL;
	}

	if (!UnregisterClass("PlayVideo", hInstance))
	{
		MessageBox(NULL, "Could Not Unregister Class", "Error", 0);
	}
}

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lp, int nCmd)
{
	if (!CreateVideoWindow(hInstance))
	{
		return FALSE;
	}

	BOOL result;
	int media_file;

	result = AML_Initializate(pWnd);
	if (!result)
	{
		MessageBox(NULL, "Failed to initializate Advanced Media Library!", "Error", 0);
		return FALSE;
	}

	const char file_name[] = "Media\\test.avi";

	result = AML_LoadMediaFile(&media_file, file_name, false);
	if (!result)
	{
		MessageBox(NULL, "Failed to load media file!", "Error", 0);
		return FALSE;
	}

	AML_Play(media_file);
	AML_SetLoop(media_file, true);

	MSG msg;

	while (TRUE)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
			{
				break;
			}
			else
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else
		{
			AML_Refresh();
		}
	}

	AML_Destroy();

	DestroyVideoWindow(hInstance);

	return TRUE;
}